import bpy
from ..core import state
from . import update


class StartRecordingButton(bpy.types.Operator):
    bl_idname = "dollars.startrecording"
    bl_label = "Start Recording"

    @classmethod
    def poll(cls, context):
        return state.server.is_alive()

    def invoke(self, context, event):
        state.is_recording = True
        return {'FINISHED'}


class StopRecordingButton(bpy.types.Operator):
    bl_idname = "dollars.stoprecording"
    bl_label = "Stop Recording"

    @classmethod
    def poll(cls, context):
        return state.server.is_alive()

    def invoke(self, context, event):
        state.is_recording = False
        return {'FINISHED'}
