bl_info = {
    "name": "Dollars MoCap",
    "author": "SunnyView Tech",
    "description": "Dollars MoCap Addon",
    "blender": (2, 83, 5),
    "version": (0, 9, 0),
    "location": "View3D > Sidebar",
    "warning": "",
    "category": "Animation"
}

import bpy
import importlib
import sys
from pathlib import Path
from bpy.types import (Operator,
                       Panel,
                       PropertyGroup,
                       UIList)
from bpy.props import (IntProperty,
                       BoolProperty,
                       StringProperty,
                       CollectionProperty,
                       PointerProperty)
from bpy.app.handlers import persistent

# Get current plugin directory name (automatically, avoid hardcoding)
__folder_name__ = Path(__file__).parent.name

# Import modules conventionally
from . import core
from . import operators
from . import panels
from .core import state, config, server, applier, bone_mapper, hip_calculator, mesh_collection
from .operators import connect, record, update, export
from .panels import main, remapping

def register():
    # Register mesh module
    mesh_collection.register()

    from .core.bone_mapper import on_target_armature_update, poll_armature

    # Property registration
    bpy.types.Scene.dollars_performer_port = bpy.props.StringProperty(
        name="Port",
        default="40339"
    )
    bpy.types.Scene.dollars_target_armature = bpy.props.PointerProperty(
        name="Armature",
        poll=poll_armature,
        type=bpy.types.Object,
        update=on_target_armature_update
    )
    bpy.types.Scene.dollars_receive_frame_rate = 60
    
    # Register classes
    bpy.utils.register_class(main.MainPanel)
    bpy.utils.register_class(remapping.RemappingPanel)

    bpy.utils.register_class(connect.ConnectButton)
    bpy.utils.register_class(connect.DisconnectButton)
    bpy.utils.register_class(record.StartRecordingButton)
    bpy.utils.register_class(record.StopRecordingButton)
    bpy.utils.register_class(update.UpdateModal)
    bpy.utils.register_class(export.ExportMappingsButton)
    bpy.utils.register_class(export.ImportMappingsButton)

    bpy.types.Scene.dollars_hip_height = bpy.props.FloatProperty(
        name="Hip Height",
        description="Height of hips from ground (used for motion adjustment)",
        default=1.0
    )
    
    remapping.register()

    # Call core.config register method
    config.register()

def unregister():
    # Stop server (if running)
    if state.server and state.server.is_alive():
        state.server.stop()
    
    # Unregister mesh module
    mesh_collection.unregister()
    
    # Delete scene properties
    del bpy.types.Scene.dollars_performer_port
    del bpy.types.Scene.dollars_target_armature
    del bpy.types.Scene.dollars_receive_frame_rate
    del bpy.types.Scene.dollars_hip_height
    
    # These may be conditionally created, so check first
    if hasattr(bpy.types.Scene, "blendshape_remap_d"):
        del bpy.types.Scene.blendshape_remap_d
    if hasattr(bpy.types.Scene, "blendshape_remap_index_d"):
        del bpy.types.Scene.blendshape_remap_index_d

    # Unregister classes
    bpy.utils.unregister_class(main.MainPanel)
    bpy.utils.unregister_class(remapping.RemappingPanel)

    bpy.utils.unregister_class(connect.ConnectButton)
    bpy.utils.unregister_class(connect.DisconnectButton)
    bpy.utils.unregister_class(record.StartRecordingButton)
    bpy.utils.unregister_class(record.StopRecordingButton)
    bpy.utils.unregister_class(update.UpdateModal)
    bpy.utils.unregister_class(export.ExportMappingsButton)
    bpy.utils.unregister_class(export.ImportMappingsButton)

    remapping.unregister()

    # Call core.config unregister method
    config.unregister()

# Execute when script is run directly
if __name__ == "__main__":
    register()