import bpy
from ..core import state
from ..core.config import Config
from ..core.applier import Applier

class ConnectButton(bpy.types.Operator):
    bl_idname = "dollars.connect"
    bl_label = "Start Listening"
    bl_description = "Connect with Dollars MoCap Program"

    @classmethod
    def poll(cls, context):
        if context.scene.dollars_performer_port == "":
            return False
        if (not context.scene.dollars_target_armature) and (len(context.scene.dollars_mesh_collection.items) == 0):
            return False
        if state.server.is_alive():
            return False
        return True

    def invoke(self, context, event):
        state.config = Config()
        target_armature = bpy.context.scene.dollars_target_armature
        if target_armature and target_armature.type == 'ARMATURE':
            if not hasattr(state, 'applier'):
                state.applier = Applier()
        state.server.start("0.0.0.0",
                           int(context.scene.dollars_performer_port))
        bpy.ops.dollars.update()
        return {'FINISHED'}


class DisconnectButton(bpy.types.Operator):
    bl_idname = "dollars.disconnect"
    bl_label = "Stop Listening"
    bl_description = "Disconnect with Dollars MoCap Program"

    @classmethod
    def poll(cls, context):
        if state.is_recording:
            return False
        return True

    def invoke(self, context, event):
        state.server.stop()
        state.is_recording = False
        return {'FINISHED'}
