from collections import deque

import bpy
import traceback
from . import state
from . import utility
from ..panels.remapping import TARGET_BLENDSHAPES
import copy
from mathutils import Vector
from mathutils import Vector, Quaternion, Matrix, Euler
import math


class Applier:
    def __init__(self):
        self.shapekey_queue = {}
        self.used_shapekeys = deque([])
        self.faceObjNames = ""
        self.shapeKeyLists = []
        self.currentFrame = 0
        self.prevTime = 0
        self.startFrame = 0
        self.bones = {}

    def update(self, address, args):
        if address == "/Dollars/Ext/Root/Pos":
            pass
#            self.update_root(args)
        if address == "/Dollars/Ext/Bone/Pos":
            self.update_pose(args)
        if address == "/Dollars/Ext/Blend/Val":
            self.accumulate_blendshape(args)
        if address == "/Dollars/Ext/Blend/Apply":
            self.update_blendshape()

    def update_root(self, args):
        pose = utility.convert_root(args)

        state.config.root.location = pose["location"]
        state.config.root.rotation_quaternion = pose["rotation_quaternion"]

    def update_pose(self, args):
        bone = None
        if state.config.humanoid_to_bone.get(args[0]):
            bone = state.config.humanoid_to_bone[args[0]]
        else:
            return

        pose = utility.convert_pose(args)
        rotation_mode = bone.pose_bone.rotation_mode
        bone.pose_bone.rotation_mode = 'QUATERNION'
        if args[0] == "Hips":
            bone.pose_bone.rotation_quaternion = pose["rotation_quaternion"]
            if state.config.humanoid_to_bone.get("root"):
                state.config.humanoid_to_bone["root"].pose_bone.location = pose["location"]
        else:
            bone.pose_bone.rotation_quaternion = pose["rotation_quaternion"]
        bone.pose_bone.rotation_mode = rotation_mode

    def accumulate_blendshape(self, args):
        if args[1] == 0.0:
            return
        if not self.shapekey_queue.get(args[0]):
            self.shapekey_queue[args[0]] = 0.0
        self.shapekey_queue[args[0]] += args[1]

    def update_blendshape(self):
        """Update shape keys using target object name and remap blendshapes according to configuration"""

        mesh_collection = bpy.context.scene.dollars_mesh_collection

        for item in mesh_collection.items:
            obj = item.mesh_object
            if obj and obj.name:
                self.apply_blendshapes_to_target(obj.name)
        self.shapekey_queue = {}


    def apply_blendshapes_to_target(self, target_name):
        """Apply blendshapes to a specific target"""
        # Get all shape keys from the target object
        shape_key_list = self.get_shapeKeys(target_name)
    
        # Apply shape key values
        shape_keys_applied = 0
        for blendshape_name, value in self.shapekey_queue.items():
 #           try:
            # Find the remapped source blendshape name
            remapped_name = bpy.context.scene.blendshape_remap_d[TARGET_BLENDSHAPES.index(blendshape_name)].source
       
            # Find and apply the remapped shape key
            for shape_key in shape_key_list:
                if shape_key.name == remapped_name:
                    shape_keys_applied += 1
                    self.set_shapeKey(shape_key, value)
                    break
    
    def get_shapeKeys(self, targetName):
        """Get all shape keys from the target object and its children"""
        if not self.faceObjNames == targetName:
            if bpy.data.objects.get(targetName) is not None:
                self.faceObjNames = targetName
                self.shapeKeyLists.clear()
                hierarchyList = self.return_hierarchy(bpy.data.objects.get(targetName))
                
                for ob in hierarchyList:
                    if ob.type == "MESH" and hasattr(ob.data, 'shape_keys') and ob.data.shape_keys:
                        for key_block in ob.data.shape_keys.key_blocks:
                            self.shapeKeyLists.append(key_block)
            elif bpy.data.shape_keys.get(targetName) is not None:
                self.shapeKeyLists.clear()
                for key_block in bpy.data.shape_keys.get(targetName).key_blocks:
                    self.shapeKeyLists.append(key_block)
        return self.shapeKeyLists
    
    def return_hierarchy(self, obj):
        """Return the object and all its descendants in a list"""
        hierarchy = [obj]
        for child in obj.children:
            hierarchy.extend(self.return_hierarchy(child))
        return hierarchy
    
    def set_shapeKey(self, shapeKey_block, value):
        """Set the value of a shape key"""
        shapeKey_block.value = value
