import bpy
from mathutils import Vector, Quaternion, Matrix, Euler
import math

from ..core import state

def convert_root(args):
    result_q = Quaternion((args[7], args[4], args[6], -args[5]))
    result_l = Vector((-args[1], -args[3], args[2]))
    return {"location": result_l, "rotation_quaternion": result_q}

def convert_pose(args):
    humanoid_bone = state.config.humanoid_to_bone[args[0]]
    parent_quaternion = humanoid_bone.parent_quaternion
    local_rotation = humanoid_bone.local_rotation
    
    incoming_rotation = Quaternion((args[7], args[4], args[6], -args[5]))
    result_l = Vector((0, 0, 0))

    if args[0] == "Hips":
        root_quaternion = state.config.humanoid_to_bone["root"].parent_quaternion
        result_l = root_quaternion.inverted(
        ) @ ((Vector((-args[1], -args[3], args[2])) - Vector((-0.0000, -0.0025, 0.8788))) * bpy.context.scene.dollars_hip_height / 0.8788)

    result_q: Quaternion = parent_quaternion.inverted() @ incoming_rotation @ parent_quaternion
    return {"location": result_l, "rotation_quaternion": result_q}

