import bpy
from mathutils import Vector


def update_hip_bone(self, context):
    hip_bone_name = self.dollars_bones_Hips
    
    if not hip_bone_name or not self.dollars_target_armature:
        return
        
    armature = self.dollars_target_armature
    
    if hip_bone_name not in armature.pose.bones:
        return
    
    hip_bone = armature.pose.bones[hip_bone_name]
    world_matrix = armature.matrix_world @ hip_bone.matrix
    location = world_matrix.to_translation()
    distance = abs(location.z)
    
    self.dollars_hip_height = distance
    
    custom_data = armature.get('CUSTOM', {})
    custom_data['hip_to_root_plane_distance'] = distance
    armature['CUSTOM'] = custom_data